from Bonds import *

class BondLattice:
    def __init__(self, nSpinsX, nSpinsY):
        self.nSpinsX = nSpinsX
        self.nSpinsY = nSpinsY
        
        self.visualBondXArray = [ None ] * (nSpinsX+1)                               # a vector of null elements, nSpinsX long
        for x in range(nSpinsX+1):
            self.visualBondXArray[x] = [0] * (nSpinsY)                             # a vector of zeros nSpinsY long
            for y in range(nSpinsY):
                self.visualBondXArray[x][y] = Bonds()

        self.visualBondYArray = [ None ] * (nSpinsX)                               # a vector of null elements, nSpinsX long
        for x in range(nSpinsX):
            self.visualBondYArray[x] = [0] * (nSpinsY+1)                             # a vector of zeros nSpinsY long
            for y in range(nSpinsY+1):
                self.visualBondYArray[x][y] = Bonds()


        self.addBonds()


                

    ## BOND METHODS

    def addBonds(self):       
        for x in range(self.nSpinsX+1):
            for y in range(self.nSpinsY):              
                boxPos = (x/2.0-self.nSpinsX+0.25,y/2.0-self.nSpinsY+0.5,0.0)
                length = 0.25
                width = 0.05
                height = 0.05
                self.visualBondXArray[x][y].setBox(boxPos, length, width, height)
                
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY+1):
                boxPos = (x/2.0-self.nSpinsX+0.5,y/2.0-self.nSpinsY+0.25,0.0)
                length = 0.05
                width = 0.05
                height = 0.25
                self.visualBondYArray[x][y].setBox(boxPos, length, width, height)



            
    def updateBonds(self, nLattice):
        for x in range(self.nSpinsX+1):
            for y in range(self.nSpinsY):
                z = nLattice.returnBondXEnergies()[x][y]*nLattice.returnCouplingX()[(x-1)%self.nSpinsX][(x)%self.nSpinsX]
                color = (z,0.0,1.0-z)
                self.visualBondXArray[x][y].setColor(color)

                
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY+1):
                z = nLattice.returnBondYEnergies()[x][y]*nLattice.returnCouplingY()[(y-1)%self.nSpinsY][(y)%self.nSpinsY]
                color = (z,0.0,1.0-z)
                self.visualBondYArray[x][y].setColor(color)



    def toggleBonds(self):
        for x in range(self.nSpinsX+1):
            for y in range(self.nSpinsY):
                self.visualBondXArray[x][y].toggleBondVisibility()
                
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY+1):
                self.visualBondYArray[x][y].toggleBondVisibility()

